-- Owner für DemoDaten
SET SESSION AUTHORIZATION 'DEMODATA';

DO $$
  DECLARE

  aknr          varchar := 'VERSCHR';
  akbez         varchar := 'Set Verschraubungen';
  akmgc         integer;

  mat_1_aknr    varchar := 'SCHRAUBE GRUND';
  mat_1_akbez   varchar := 'Schraube Grundartikel';
  mat_1_mgc     integer;
  mat_2_aknr    varchar := 'UNTERLEGSCHEIBE';
  mat_2_akbez   varchar := 'Unterlegscheibe';
  mat_2_mgc     integer;
  mat_3_aknr    varchar := 'MUTTER GRUND';
  mat_3_akbez   varchar := 'Mutter Grundartikel';
  mat_3_mgc     integer;
  ---
  opix          integer := nextval( 'opl_op_ix_seq' );
  o2id          integer;
  ldid          integer;
  abix          integer;
  ---
  w_wen_mutter_alt_1      integer;
  w_wen_mutter_alt_2      integer;
  w_wen_mutter_grund      integer;
  w_wen_schraube_alt_1    integer;
  w_wen_schraube_alt_2    integer;
  w_wen_schraube_grund    integer;
  w_wen_unterlegscheibe   integer;

 BEGIN

    PERFORM tartikel.art__ak_nr__delete( ak_nr )
    FROM art
    WHERE ak_nr in( aknr, mat_1_aknr, mat_2_aknr, mat_3_aknr );

    --- Artikel anlegen
    INSERT INTO art ( ak_ac   , ak_nr, ak_bez, ak_lag)
      VALUES        ( 'PR1001', aknr , akbez , false);
    ---
    INSERT INTO art ( ak_ac   , ak_nr     , ak_bez     , ak_lag)
      VALUES        ( 'KT1001', mat_1_aknr, mat_1_akbez, false);
    ---
    INSERT INTO art ( ak_ac   , ak_nr     , ak_bez     , ak_lag)
      VALUES        ( 'KT1001', mat_2_aknr, mat_2_akbez, false);
    ---
    INSERT INTO art ( ak_ac   , ak_nr     , ak_bez     , ak_lag)
      VALUES        ( 'KT1001', mat_3_aknr, mat_3_akbez, false);

  akmgc     := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(aknr);
    mat_1_mgc := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_1_aknr);
    mat_2_mgc := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_2_aknr);
    mat_3_mgc := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_3_aknr);

    PERFORM tartikel.art__ak_nr__delete( ak_nr )
    FROM art
    WHERE ak_nr in( 'SCHRAUBE ALT 1', 'SCHRAUBE ALT 2', 'MUTTER ALT 1', 'MUTTER ALT 2' );

  --- Alternativ-Artikel
  INSERT INTO art ( ak_ac   , ak_nr           , ak_bez                        , ak_lag)
      VALUES        ( 'PR1001', 'SCHRAUBE ALT 1', 'Schraube Alternativartikel 1', false);
  ---
  INSERT INTO art ( ak_ac   , ak_nr           , ak_bez                        , ak_lag)
      VALUES        ( 'PR1001', 'SCHRAUBE ALT 2', 'Schraube Alternativartikel 2', false);
  ---
  INSERT INTO art ( ak_ac   , ak_nr           , ak_bez                    , ak_lag)
      VALUES        ( 'PR1001', 'MUTTER ALT 1', 'Mutter Alternativartikel 1', false);
  ---
  INSERT INTO art ( ak_ac   , ak_nr           , ak_bez                    , ak_lag)
      VALUES        ( 'PR1001', 'MUTTER ALT 2', 'Mutter Alternativartikel 2', false);

  --- INSERT INTO adk ( ad_krz ) VALUES ( '#' );

  --- Kostenstelle
  --INSERT INTO ksv ( ks_abt ) VALUES ( 'MON-PERS' );

  --- AVOR
    INSERT INTO opl
      ( op_n, op_ix, op_vi )
     VALUES
      ( aknr, opix ,     1 );
    ---
    INSERT INTO op2 --Montieren Halle 1
      ( o2_ix, o2_n, o2_txt                  , o2_ks     , o2_tv )
     VALUES
      ( opix ,   10, 'Montage Gesamtpersonal', 'MON-PERS', 10 )
   RETURNING o2_id INTO o2id ;

    --- Stückliste
   INSERT INTO stv
      (st_zn, st_n      , st_m, st_mgc  , st_pos )
     VALUES
      (aknr , mat_1_aknr, 1   , mat_1_mgc, COALESCE((SELECT MAX(st_pos) + 10 FROM stv WHERE st_zn = aknr), 10));
    ---
    INSERT INTO stv
      (st_zn, st_n      , st_m, st_mgc  , st_pos )
     VALUES
      (aknr , mat_2_aknr, 1   , mat_2_mgc, COALESCE((SELECT MAX(st_pos) + 10 FROM stv WHERE st_zn = aknr), 20));
    ---
    INSERT INTO stv
      (st_zn, st_n      , st_m, st_mgc  , st_pos )
     VALUES
      (aknr , mat_3_aknr, 1   , mat_3_mgc, COALESCE((SELECT MAX(st_pos) + 10 FROM stv WHERE st_zn = aknr), 30));

    --- Lagezugang
    INSERT INTO wendat
        ( w_aknr           , w_lgort, w_lagort, w_zugang, w_zug_mec )
      VALUES
        ( 'MUTTER ALT 1'   , 'MUTT1', 'MUTT1' , 40      , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('MUTTER ALT 1') )
    RETURNING w_wen INTO w_wen_mutter_alt_1;

    INSERT INTO wendat
        ( w_aknr           , w_lgort, w_lagort, w_zugang, w_zug_mec )
      VALUES
        ( 'MUTTER ALT 2'   , 'MUTT1', 'MUTT1' , 40      , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('MUTTER ALT 2') )
    RETURNING w_wen INTO w_wen_mutter_alt_2;

    INSERT INTO wendat
        ( w_aknr           , w_lgort, w_lagort, w_zugang, w_zug_mec )
      VALUES
        ( 'MUTTER GRUND'   , 'MUTT1', 'MUTT1' , 40      , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(mat_3_aknr) )
    RETURNING w_wen INTO w_wen_mutter_alt_1;

    INSERT INTO wendat
        ( w_aknr           , w_lgort, w_lagort, w_zugang, w_zug_mec )
      VALUES
        ( 'SCHRAUBE ALT 1' , 'SCHR1', 'SCHR1' , 20      , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('SCHRAUBE ALT 1') )
    RETURNING w_wen INTO w_wen_schraube_alt_1;

    INSERT INTO wendat
        ( w_aknr           , w_lgort, w_lagort, w_zugang, w_zug_mec )
      VALUES
        ( 'SCHRAUBE ALT 2' , 'SCHR1', 'SCHR1' , 10      , tartikel.me__art__artmgc__m_id__by__ak_standard_mgc('SCHRAUBE ALT 2') )
    RETURNING w_wen INTO w_wen_schraube_alt_2;

    INSERT INTO wendat
        ( w_aknr           , w_lgort, w_lagort, w_zugang, w_zug_mec )
      VALUES
        ( 'SCHRAUBE GRUND' , 'SCHR1', 'SCHR1' , 25      , mat_1_mgc )
    RETURNING w_wen INTO w_wen_schraube_grund;

    INSERT INTO wendat
        ( w_aknr           , w_lgort, w_lagort, w_zugang, w_zug_mec )
      VALUES
        ( 'UNTERLEGSCHEIBE', 'UNT1' , 'UNT1'  , 30      , mat_2_mgc )
    RETURNING w_wen INTO w_wen_unterlegscheibe;

    ---
  INSERT INTO ldsdok (ld_ep, ld_kn, ld_mce, ld_pos, ld_stk, ld_aknr, ld_arab, ld_code, ld_done, ld_krzf, ld_krzl, ld_kurs,
            ld_term          , ld_auftg       , ld_datum    , ld_eklos, ld_sperr, ld_terml        , ld_ep_uf1,
            ld_storno, ld_kontakt, ld_nbedarf, ld_ltastatus, ld_rech_eing, ld_ep_basis_w,
            ld_interncreate, ld_preiseinheit, ld_netto_basis_w, ld_brutto_basis_w, ld_ep_uf1_basis_w )
      VALUES           ( 0   , '#'  , akmgc , 10    , 5     , aknr   , 0      , 'I'    , false   , '#'    , '#'    , 1     ,
            current_date + 15, 'PA23-00111/10', current_date, 1       , false   , current_date + 15, 0        ,
            false    , 'DEMO'     , true      , false       , false      , 0            ,
            false          , 1              , 0               , 0                , 0 )
      RETURNING ld_id INTO ldid;
    ---

    INSERT INTO abk ( ab_at            , ab_et            , ab_buch, ab_done, ab_stat   , ab_ap_nr, ab_askix, ab_ld_id, ab_nk_agk, ab_dolager,
           ab_erstfert, ab_keyvalue    , ab_doeinkauf, ab_inplantaf, ab_nk_change, ab_nk_st_uf1, ab_displaycaption )
      VALUES        ( current_date + 15, current_date + 15, false  , true   , 'BGr-STD', 'VERSCHR', opix    , ldid    , 15       , true      ,
           true       , 'PA23-00111/10', true        , true        , true        , 1           , 'I | PA23-00111/10 | 10' )
      RETURNING ab_ix INTO abix;

    ---
    INSERT INTO ab2 ( a2_n, a2_at            , a2_et            , a2_ks     , a2_tv, a2_txt                  , a2_ende, a2_prio, a2_ab_ix, a2_o2_id, a2_interm, a2_th_sek, a2_awpreis, a2_subject              , a2_zeinh_tr, a2_zeinh_tx, a2_time_stemp__ruest_overlap )
      VALUES        ( 10  , current_date + 15, current_date + 15, 'MON-PERS', 10   , 'Montage Gesamtpersonal', true   , 1      , abix    , o2id    , true     , 0        , 0         , 'Montage und Verpackung', 1          , 2          , 0 );

    ---
    UPDATE ldsdok SET ld_abk = abix WHERE ld_id = ldid;

    -- Verknüpfung der Alternativartikel fehlt in Demodaten
    INSERT INTO artoption_arts
      ( aoa_pos,        aoa_g_ak_nr,      aoa_ak_nr   )
    VALUES
      (       1,   mat_3_aknr, 'MUTTER ALT 1'   ),
      (       2,   mat_3_aknr, 'MUTTER ALT 2'   ),
      (       1,   mat_1_aknr, 'SCHRAUBE ALT 1' ),
      (       2,   mat_1_aknr, 'SCHRAUBE ALT 2' );


    -- Material aus Stückliste fehlt in Demodaten
    INSERT INTO auftg
      ( ag_astat, ag_nr , ag_pos, ag_aknr          ,  ag_stk, ag_lkn, ag_parentabk )
    VALUES
      ( 'I'     , 'PA-1', 10    , 'SCHRAUBE GRUND' ,  50    , '#'   , abix ),
      ( 'I'     , 'PA-1', 20    , 'MUTTER GRUND'   ,  50    , '#'   , abix ),
      ( 'I'     , 'PA-1', 30    , 'UNTERLEGSCHEIBE',  50    , '#'   , abix );

 END $$;

-- END DEMO-SESSION
RESET SESSION AUTHORIZATION;